﻿var editPhoneTemplateRule = {
    context: $(".v-editPhoneTemplateRule"),
    initialize: function () {
        editPhoneTemplateRule.setAutoNumericRuleConditionInput();

        $(".h-LineGroupPriority-autocomplete", editPhoneTemplateRule.context).each(function () {
            $(this).a4autocomplete({
                ajaxAction: a4.getAction("GetStringVariablesForAutoComplete", "MultiMode", "Settings"),
                valueProperty: "Id",
                labelProperty: "Name",
                multipleSelection: true,
                hideSelectedItems: true
            });
        });

        $(".h-summary").tooltip({
            content: function (callback) {
                callback($(this).prop('title').replace(/\|/g, '<br />'));
            }
        });

        a4.initializeInputs(editPhoneTemplateRule.context);

        editPhoneTemplateRule.bindEvents();    
    },
    bindEvents: function () {
        this.context.on("click", "#CreatePhoneTemplateRule", function () {
            if ($("#Name", editPhoneTemplateRule.context).val().indexOf("<") == 0) {
                var name = $("#Name", editPhoneTemplateRule.context).val().substring(1, $("#Name").val().length - 1);
                $("#Name", editPhoneTemplateRule.context).val(name);
            }
        });

        this.context.on("click", ".v-addConditionRow", function () {
            var newRow = $(".v-newItem tbody", editPhoneTemplateRule.context).clone().html();
            $(".h-condition-dynamicTable tbody", editPhoneTemplateRule.context).append(newRow);
            editPhoneTemplateRule.setAutoNumericRuleConditionInput();
            editPhoneTemplateRule.refreshRuleConditionTable();
        });

        this.context.on("click", ".h-condition-dynamicTable .h-deleteRuleCondition", function () {
            $(this).closest("tr").remove();
            editPhoneTemplateRule.refreshRuleConditionTable();
        });

        this.context.on("keypress", ".h-condition-dynamicTable .v-editableItem input", function (e) {
            return (e.keyCode != 13);
        });
    },
    refreshRuleConditionTable: function () {
        var i = 0;

        $(".h-condition-dynamicTable tr td input", editPhoneTemplateRule.context).each(function () {
            $(this).attr("id", "Conditions_" + i + "__Condition");
            $(this).attr("name", "Conditions[" + i + "].Condition");
            i++;
        });
    },
    setAutoNumericRuleConditionInput: function () {
        $(".h-condition-dynamicTable .v-editableItem input[type=text]", editPhoneTemplateRule.context).autoNumeric({ vMin: '0', vMax: '999999999999', mDec: '0', aSep: '' });
    }
}

$(document).ready(function () {
    if (editPhoneTemplateRule.context.length > 0) {
        editPhoneTemplateRule.initialize();
    }
});